state W3MeteorFrostSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var energy_area   									: SpellsEnergyArea;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3EnergyDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;
	var vector_attach 									: Vector;
	var randRoll										: float;


	event OnEnterState( prevStateName : name )
	{
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_meteorfrost();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_meteorfrost()
	{
		var venom						: W3GreatSwampVenom;
		var effect1,effect2				: CEntity;
		var elactors					: array<CActor>;
		var elactor0,elactor1			: CActor;
		var meteorPosition				: Vector;
		var nbr, g						: int;
		var speed 						: float;
		var meteorEntity 				: W3MeteorFrostSpells;
		var marker					 	: CEntity;
	
		if ( parent.spell_name == 'meteor_frost' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				if ( ((CNewNPC) parent.actor).IsInInterior() )
				{
					theGame.GetGuiManager().ShowNotification( GetLocStringByKeyExt( "menu_cannot_perform_action_here" ),, true );
				}
				else
				{
					nbr = Clamp(Max( 1,( RoundMath( GetMagicVigil().get_magic_spellpower() * 100 ) / 50 ) ), 1, 6 );
					
					//theGame.witcherLog.AddMessage("NUMBER   :   " + nbr );
					
					for ( g=0; g < nbr; g += 1 )
					{
						if (g==0)
						{
							targetPosition = parent.actor.GetWorldPosition();
						}
						else if ( g!=0 )
						{
							targetPosition = parent.actor.GetWorldPosition();
							if( RandF() <= 0.5 )
							{
								targetPosition.X += RandRange( 5, 2);
								targetPosition.Y += RandRange( 5, 2);
							}
							else
							{
								targetPosition.X -= 2;
								targetPosition.Y -= 2;
							}
						}
						
						meteorPosition = targetPosition;
						meteorPosition.Z += 30;
						
						meteorEntity = ( W3MeteorFrostSpells )theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\meteorite_frost.w2ent", true ), meteorPosition );
						meteorEntity.Init(NULL);
						meteorEntity.PlayEffect('smoke');
						speed = 25;
						if ( g==0 )
						{
							speed = 20;
						}
						else if( g!=0 )
						{
							speed = 10 + RandRange( 20 );
						}
						meteorEntity.ShootProjectileAtPosition( 0, speed, targetPosition, 500 );
						
						marker = theGame.CreateEntity( (CEntityTemplate)LoadResource( "gameplay\abilities\eredin\eredin_meteorite_marker.w2ent", true ), targetPosition, EulerAngles(0,0,0) );
						marker.StopAllEffectsAfter(2);
						marker.DestroyAfter(5);
					}	
				
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					thePlayer.SetCombatIdleStance( 1.f );
				}
			}
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}